package gov.va.med.mhv.bluebutton.model;

import gov.va.med.mhv.common.data.model.FacilityInfo;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "PHR_RADIOLOGY")
public class PhrRadiology implements Serializable {
	private static final long serialVersionUID = -6600603725383660228L;

	@Id
	@Column(name = "PHR_RADIOLOGY_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;
	
	@Column(name = "REASON_FOR_STUDY")
	private String reasonForStudy;
	
	@Column(name = "RADIOLOGIST")
	private String radiologist;
	
	@Column(name = "CLINICAL_HISTORY")
	private String clinicalHistory;
	
	@Column(name = "COMMENTS")
	private String comments;
	
	@Column(name = "CREATED_DATE")
	private Date createdDate;

	@Column(name = "IMPRESSION_TEXT")
	private String impressionText;

	@Column(name = "INPATIENT_OUTPATIENT")
	private String inPatientOutPatient;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "STATION_NUMBER")
	private String stationNumber;

	@Column(name = "PATIENT_ID")
	private long patientId;

	@Column(name = "PROCEDURE_NAME")
	private String procedureName;

	@Column(name = "STATUS")
	private String status;

	@Column(name = "REQUESTING_PROVIDER")
	private String requestingProvider;

	@Column(name = "REPORT_TEXT")
	private String reportText;

	@Column(name = "PERFORMING_LOCATION_ST_NUM")
	private String performingLocationStNum;

	@Embedded
	@AttributeOverrides({ @AttributeOverride(name = "datePrecise", column = @Column(name = "EVENT_TIME")),
			@AttributeOverride(name = "dateImprecise", column = @Column(name = "EVENT_TIME_IMPRECISE")) })
	private ImpreciseDate eventDate;

	@Embedded
	@AttributeOverrides({ @AttributeOverride(name = "datePrecise", column = @Column(name = "EXAM_DATE")),
			@AttributeOverride(name = "dateImprecise", column = @Column(name = "EXAM_DATE_IMPRECISE")) })
	private ImpreciseDate examDate;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "FACILITY_INFO_ID")
	private FacilityInfo facilityInfo;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "PHR_FACILITY_CONTROL_ID")
	private PhrFacilityControl phrFacilityControlId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getProcedureName() {
		return procedureName;
	}

	public void setProcedureName(String procedureName) {
		this.procedureName = procedureName;
	}

	public long getPatientId() {
		return patientId;
	}

	public void setPatientId(long patientId) {
		this.patientId = patientId;
	}

	public FacilityInfo getFacilityInfo() {
		return facilityInfo;
	}

	public void setFacilityInfo(FacilityInfo facilityInfo) {
		this.facilityInfo = facilityInfo;
	}

	public String getReasonForStudy() {
		return reasonForStudy;
	}

	public void setReasonForStudy(String reasonForStudy) {
		this.reasonForStudy = reasonForStudy;
	}

	public String getRadiologist() {
		return radiologist;
	}

	public void setRadiologist(String radiologist) {
		this.radiologist = radiologist;
	}

	public String getClinicalHistory() {
		return clinicalHistory;
	}

	public void setClinicalHistory(String clinicalHistory) {
		this.clinicalHistory = clinicalHistory;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getImpressionText() {
		return impressionText;
	}

	public void setImpressionText(String impressionText) {
		this.impressionText = impressionText;
	}

	public String getInPatientOutPatient() {
		return inPatientOutPatient;
	}

	public void setInPatientOutPatient(String inPatientOutPatient) {
		this.inPatientOutPatient = inPatientOutPatient;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getRequestingProvider() {
		return requestingProvider;
	}

	public void setRequestingProvider(String requestingProvider) {
		this.requestingProvider = requestingProvider;
	}

	public String getReportText() {
		return reportText;
	}

	public void setReportText(String reportText) {
		this.reportText = reportText;
	}

	public String getPerformingLocationStNum() {
		return performingLocationStNum;
	}

	public void setPerformingLocationStNum(String performingLocationStNum) {
		this.performingLocationStNum = performingLocationStNum;
	}

	public ImpreciseDate getEventDate() {
		return eventDate;
	}

	public void setEventDate(ImpreciseDate eventDate) {
		this.eventDate = eventDate;
	}

	public ImpreciseDate getExamDate() {
		return examDate;
	}

	public void setExamDate(ImpreciseDate examDate) {
		this.examDate = examDate;
	}

	public PhrFacilityControl getPhrFacilityControlId() {
		return phrFacilityControlId;
	}

	public void setPhrFacilityControlId(PhrFacilityControl phrFacilityControlId) {
		this.phrFacilityControlId = phrFacilityControlId;
	}

}
